/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.collect.Lists;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.DefaultChangeTrackingSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.UnmodifiableChangeTrackingSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottleFilter
extends Processor {
    private static final Logger log = LoggerFactory.getLogger(ThrottleFilter.class);
    private static final double PRIORITY_WEIGHT = 3.1536E10;
    private int n = 10000;
    private boolean usePriority;
    private int pos = 0;
    private List<ScoredOperation> sortedOps;
    private boolean noOperationPlanned;
    private int actualN;
    private long lastPlannedBound;
    private Set<Operation> outOps = DefaultChangeTrackingSet.create();
    private Set<Operation> outOpsView = UnmodifiableChangeTrackingSet.create((ChangeTrackingSet)this.outOps);

    public ThrottleFilter() {
        this.lastPlannedBound = Long.MIN_VALUE;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getN() {
        return this.n;
    }

    public void setUsePriority(boolean usePriority) {
        this.usePriority = usePriority;
    }

    public boolean isUsePriority() {
        return this.usePriority;
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (this.outOps.size() == 0) {
            this.sortedOps = Lists.newArrayListWithCapacity(ops.size());
            for (Operation op : ops) {
                this.sortedOps.add(new ScoredOperation(op, this.score(op)));
            }
            Collections.sort(this.sortedOps);
            this.actualN = this.n;
            this.pos = 0;
            this.fillOutOps();
        }
        if (this.noOperationPlanned) {
            long opsBound = this.minBoundFromCurrentLastOps();
            if (opsBound > this.lastPlannedBound) {
                this.lastPlannedBound = opsBound;
                log.debug("lastPlannedBound {} opsBound {}", (Object)this.lastPlannedBound, (Object)opsBound);
            }
            for (Operation op : this.outOps) {
                op.updateSimpleBound(this, this.lastPlannedBound);
            }
            this.noOperationPlanned = false;
            this.actualN *= 2;
            log.debug("Extended the buffer to {}", (Object)this.actualN);
            this.fillOutOps();
        }
        return Tuple.create(this.getDefaultSuccessor(), this.outOpsView);
    }

    private long minBoundFromCurrentLastOps() {
        long minBound = Long.MAX_VALUE;
        for (Operation op : this.outOps) {
            long bound = op.getBound().getTime();
            if (bound >= minBound) continue;
            minBound = bound;
        }
        return minBound;
    }

    @Override
    public void onOperationPlanned(Operation op) {
        this.outOps.removeAll(op.getLaOps());
        this.lastPlannedBound = op.getBound().getTime();
        this.fillOutOps();
        if (this.actualN > this.n) {
            this.actualN = this.n;
            log.debug("Shrunk the buffer back to {}", (Object)this.actualN);
        }
    }

    @Override
    public boolean onPlanningStopping() {
        this.noOperationPlanned = true;
        return this.pos >= this.sortedOps.size();
    }

    private void fillOutOps() {
        double lastScore = Double.NaN;
        boolean added = false;
        while (this.pos < this.sortedOps.size() && this.outOps.size() < this.actualN) {
            ScoredOperation newOp = this.sortedOps.get(this.pos);
            this.addOutOp(newOp.operation);
            ++this.pos;
            lastScore = newOp.score;
            added = true;
        }
        if (added) {
            while (this.pos < this.sortedOps.size() && this.sortedOps.get((int)this.pos).score == lastScore) {
                this.addOutOp(this.sortedOps.get((int)this.pos).operation);
                ++this.pos;
            }
        }
    }

    private void addOutOp(Operation op) {
        if (this.lastPlannedBound > Long.MIN_VALUE) {
            op.updateSimpleBound(this, this.lastPlannedBound);
        }
        this.outOps.add(op);
    }

    private double score(Operation op) {
        GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(op.getGar());
        return (this.usePriority ? (double)gor.getPriority() * 3.1536E10 : 0.0) + (double)gor.getDueDate();
    }

    private static class ScoredOperation
    implements Comparable<ScoredOperation> {
        double score;
        Operation operation;

        public ScoredOperation(Operation operation, double score) {
            this.operation = operation;
            this.score = score;
        }

        @Override
        public int compareTo(ScoredOperation o) {
            return Comparators.compare(this.score, o.score);
        }
    }
}

